/// <reference name="MicrosoftAjax.debug.js" />
/// <reference name="MicrosoftAjaxTimer.debug.js" />
/// <reference name="MicrosoftAjaxWebForms.debug.js" />
/// <reference name="AjaxControlToolkit.ExtenderBase.BaseScripts.js" assembly="AjaxControlToolkit" />


Type.registerNamespace('ImageRotator');

ImageRotator.ImageRotatorBehavior = function(element) {
    ImageRotator.ImageRotatorBehavior.initializeBase(this, [element]);

    this._imageIndex = 0;
    this._imageList = new Array();
    this._rotationInterval = null;
    this._timer = null;
}
ImageRotator.ImageRotatorBehavior.prototype = {
    initialize : function() {
        ImageRotator.ImageRotatorBehavior.callBaseMethod(this, 'initialize');

        var element = this.get_element();

        if(this._imageList)
        {
           this._imageList = Sys.Serialization.JavaScriptSerializer.deserialize(
                                                         this._imageList);
           this._imageList[this._imageList.length] = element.src;
        }
        
        if(this._rotationInterval == null)
            this._rotationInterval = 3;
        
        if(this._timer == null)
            this._timer = new Sys.Timer();
        
        this._timer.set_interval(this._rotationInterval * 1000);
        this._timer.add_tick(Function.createDelegate(this, this._rotateImage));
        this._timer.set_enabled(true);
    },

    dispose : function() {
        ImageRotator.ImageRotatorBehavior.callBaseMethod(this, 'dispose');

        if (this._timer) 
        {
            this._timer.dispose();
            this._timer = null;
        }
        
        this._imageList = null;

    },
    get_rotationInterval: function(){
        return this._rotationInterval;
    },
    set_rotationInterval: function(value){
        this._rotationInterval = value;
    },
    get_imageList: function(){
        return this._imageList;
    },
    set_imageList: function(value){
        this._imageList = value;
    },
    _rotateImage: function(){
        var element = this.get_element();
        if(element)
        {
            element.src = this._imageList[this._imageIndex++];
            if(this._imageIndex > this._imageList.length - 1)
                this._imageIndex = 0;
        }
    }
}
ImageRotator.ImageRotatorBehavior.registerClass(
        'ImageRotator.ImageRotatorBehavior', AjaxControlToolkit.BehaviorBase);
